/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.rs6k;

import com.ibm.hsc.cim.provider.rs6k.AsynchEventManager;
import com.ibm.hsc.common.util.CimomListener;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbemcfg.GlobalConfig;

public class IndicationSender
extends Thread {
    Vector _subscribers = null;
    int _eventType = -1;
    CIMInstance _newInstance = null;
    CIMInstance _oldInstance = null;
    Object _userObject = null;
    boolean _debug = true;
    private static Hashtable _STALE_SUBSCRIBERS = new Hashtable();
    private static long _STALE_COUNTER = 3600000L;

    public IndicationSender(Vector vector, int n, CIMInstance cIMInstance, CIMInstance cIMInstance2, Object object) {
        this._subscribers = vector;
        this._eventType = n;
        this._newInstance = cIMInstance;
        this._oldInstance = cIMInstance2;
        this._userObject = object;
    }

    public void run() {
        if (GlobalConfig.debugLevel((int)6) > 0) {
            System.out.println("One IndicationSender, " + Thread.currentThread() + " starts for event type " + this._eventType + " with newInstance " + this._newInstance);
            System.out.println("     There are " + this._subscribers.size() + " subscribers.");
        }
        if (this._subscribers == null) {
            return;
        }
        Vector vector = (Vector)this._subscribers.clone();
        Enumeration enumeration = vector.elements();
        CimomListener cimomListener = null;
        while (enumeration.hasMoreElements()) {
            cimomListener = (CimomListener)enumeration.nextElement();
            try {
                if (GlobalConfig.debugLevel((int)6) > 0) {
                    System.out.println("     Thread " + Thread.currentThread() + " Sending indication to " + cimomListener);
                }
                cimomListener.eventOccurred(this._eventType, this._newInstance, this._oldInstance, this._userObject);
                _STALE_SUBSCRIBERS.put(cimomListener, new Long(-1L));
            }
            catch (RemoteException remoteException) {
                try {
                    Long l;
                    if (GlobalConfig.debugLevel((int)6) > 0) {
                        System.out.println("     Thread: " + Thread.currentThread() + " RMI ConnectException");
                    }
                    if ((l = (Long)_STALE_SUBSCRIBERS.get(cimomListener)) == null || l == -1L) {
                        _STALE_SUBSCRIBERS.put(cimomListener, new Long(System.currentTimeMillis()));
                        continue;
                    }
                    long l2 = l;
                    long l3 = System.currentTimeMillis();
                    if (l3 - l2 < _STALE_COUNTER) continue;
                    if (GlobalConfig.debugLevel((int)6) > 0) {
                        System.out.println("<<<<<<<<<<<<<<<<<<<< STALED >>>>>>>>>>>>>>>>>>>>");
                        System.out.println("Thread: " + Thread.currentThread());
                        System.out.println("oldTime = " + l2);
                        System.out.println("newTime = " + l3);
                    }
                    AsynchEventManager.removeStaleData(cimomListener);
                    _STALE_SUBSCRIBERS.remove(cimomListener);
                    if (GlobalConfig.debugLevel((int)6) <= 0) continue;
                    System.out.println("<<<<<<<<<<<<<<<<<<<< END STALED >>>>>>>>>>>>>>>>>>>>");
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                if (GlobalConfig.debugLevel((int)6) <= 0) continue;
                System.out.println("     Thread: " + Thread.currentThread());
                throwable.printStackTrace();
            }
        }
    }

    public static void removeSubscriber(CimomListener cimomListener) {
        _STALE_SUBSCRIBERS.remove(cimomListener);
    }
}

